function param = StarkShift_allmixed_N2_HF(N_X, I)

%% This is the main file to run

PlotFlag = 3; % 1 to plot both ac_shift and sc rate. 2 for only ac-shift in [GHz], 3 for only ac-shift in [nm]

%% Given an initial ground state and the nuclear-spin, this file calculates ac-stark shift for all possible levels

% Defining the spins
S_X = 0.5;
I_X = I;
%L = 782.647:0.0000001:782.658;     % [nm] Laser frequency
%L = 787.471:0.0000001:787.48;
% L = 787.4700:0.000001:787.4820;
%L = 787.4745:0.000001:787.4765;

% L = 781.0:0.00001:783.0; % [nm] R21(1/2), Q21(1/2) and R11(1/2) lines 
%L = 782.6526:0.000000001:782.6535; % [nm] R21(1/2) line
%L = 782.9706:0.000000001:782.9723; % [nm] Q21(1/2) line
% L = 786.5:0.0001:788.5% [nm] R11(1/2) line
L = 787.44:0.00001:787.46;
jj = 0;

for J_X = abs(N_X-S_X):1:(N_X+S_X)
    
    if (N_X == J_X - 0.5)
        Fn_X = 1;
    elseif (N_X == J_X + 0.5)
        Fn_X = 2;
    else
        disp('Bad J''''');
        return;
    end
    
    for F_X = abs(J_X-I_X):1:(J_X+I_X)
        for MF_X = 0.5:1:F_X                % Only calculating for positive hyperfine projections. Negative projections will have same results
            T = {['P1' num2str(Fn_X) '(' num2str(J_X*2) '/2)'], ['Q1' num2str(Fn_X) '(' num2str(J_X*2) '/2)'], ['R1' num2str(Fn_X) '(' num2str(J_X*2) '/2)'], ...
                ['P2' num2str(Fn_X) '(' num2str(J_X*2) '/2)'], ['Q2' num2str(Fn_X) '(' num2str(J_X*2) '/2)'], ['R2' num2str(Fn_X) '(' num2str(J_X*2) '/2)']};
            %disp(['Fn'''' :', num2str(Fn_X), ', J'''' :', num2str(J_X), ', F'''' :', num2str(F_X), ', MF'''' :', num2str(MF_X)]);
            jj = jj + 1;
            ac_total{jj}=0;
            sc_total{jj} = 0;
            for ii = 1:1:6
                %Calculate ac-Stark shift
                %Function format ac_Stark_mixed_HF(T{ii}, I, F_X, MF_X, L);
                %L in [nm]
                %disp(T{ii});
                
                z = ac_Stark_allmixed_hfs(T{ii}, I, F_X, MF_X, L);
                ac_total{jj} = ac_total{jj} + z{1};
                sc_total{jj} = sc_total{jj} + z{2};
            end
            txt{jj} = ['N'''' = ', num2str(N_X), ', J'''' = ', num2str(J_X), ', F'''' = ', num2str(F_X), ', MF'''' = ', num2str(MF_X)];
            
        end
    end
end


%% Plotting

if(PlotFlag ==1)
    f=figure;
    pos=[0.13 0.125 0.735 0.8];
    ax1=axes('position',pos,'box','off','color','none','xaxislocation','bottom','yaxislocation','left','fontsize',14,'yscale','log');
    hold on;
    ax2=axes('position',pos,'box','off','color','none','xaxislocation','top','yaxislocation','right','fontsize',14,'yscale','log', 'Xtick', []);
    hold on;
    for ii = 1:1:jj
        plot(ax1, L, abs(ac_total{ii}), '-', 'linewidth', 2);
        plot(ax2, L, abs(sc_total{ii}), '--', 'linewidth', 2);
    end
    xlabel(ax1, '\omega [nm]');
    ylabel(ax1, '|\DeltaE| [Hz]');
    ylabel(ax2, '\Gamma_{sc} [Hz]');
    xlim(ax1, [min(L) max(L)]);
    xlim(ax2, [min(L) max(L)]);
    ylim(ax1, [1e0 1e8]);
    ylim(ax2, [1e-6 1e4]);
    legend(txt, 'location', 'southeast');
elseif(PlotFlag ==2)
    figure;
    hold on;
    cl=299792458; % Speed of light in [m/sec]
    
    %c_freq = cl*(XA20bandTrans_Wu('R11(1/2)')*1e2); %Central Frequency in [Hz]
    %det = (cl./(L) - c_freq/1e9); % detuning in [GHz]
    
    for ii = 1:1:jj
        plot((cl./(L*1e-9) - cl/(0.5*(min(L)+max(L))*1e-9))*1e-9, abs(ac_total{ii}), '-', 'linewidth', 2);
        %plot(det, abs(ac_total{ii})/2, '-', 'linewidth', 2);
    end
    
    xlabel(['\nu - ', num2str(cl/(0.5*(min(L)+max(L))*1e-9)*1e-9), ' [GHz]']);
    ylabel('|\DeltaE| [Hz]');
    %xlim([-0.6 0.5]);
    %ylim([3e4 5e10]);
    set(gca, 'YScale', 'log', 'Fontsize', 12);
    legend(txt, 'location', 'southeast');
    box on;
elseif(PlotFlag == 3)
    figure;
    %gray=[0.8700    0.8700    0.8700];
    %x = [787.4755-0.0025 787.4755+0.0025];
    %y = [1e12 1e12];
    %area(x,y,'facecolor',gray,'linestyle','none','showbaseline','off');
    hold on;
    for ii = 1:1:jj
        plot(L, abs(ac_total{ii}), '-', 'linewidth', 2, 'DisplayName', txt{ii});
        %plot(L, (ac_total{ii}), '-', 'linewidth', 2, 'DisplayName', txt{ii});
        %plot(L, (ac_total{ii})/1e8, '-', 'linewidth', 2);
    end
    
    xlabel('\omega [nm]');
    ylabel('|\DeltaE| [Hz]');
    set(gca, 'YScale', 'log', 'Fontsize', 14);
    legend(txt, 'location', 'southeast');
    box on;
end


% Formatting data to be returned into a cell.
% Returns wavelength, ac_shift and legend
for ii = 1:1:jj
    param{ii, 1} = L;
    param{ii, 2} = ac_total{ii};
    param{ii, 3} = sc_total{ii};
    param{ii, 4} = txt{ii};
end

end